/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.NBTTags;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IFaction;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.data.FactionOptions;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;
import noppes.npcs.entity.EntityNPCInterface;

public class Faction
implements IFaction {
    public HashSet<Integer> attackFactions = new HashSet();
    public HashSet<Integer> frendFactions = new HashSet();
    public int id = -1;
    public int color = Integer.parseInt("FF00", 16);
    public int defaultPoints = 1000;
    public int friendlyPoints = 1500;
    public int neutralPoints = 500;
    public boolean getsAttacked = false;
    public boolean hideFaction = false;
    public String name = "";
    public String description = "";
    public ResourceLocation flag = new ResourceLocation("customnpcs:textures/cloak/mojang.png");
    public FactionOptions factions = new FactionOptions();

    public Faction() {
    }

    public Faction(int id, String name, int color, int defaultPoints) {
        this();
        this.id = id;
        this.name = name;
        this.color = color;
        this.defaultPoints = defaultPoints;
    }

    @Override
    public void addHostile(int id) {
        if (this.attackFactions.contains(id)) {
            throw new CustomNPCsException("Faction " + id + " is already hostile to " + id, new Object[0]);
        }
        this.attackFactions.add(id);
    }

    @Override
    public boolean getAttackedByMobs() {
        return this.getsAttacked;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public int getDefaultPoints() {
        return this.defaultPoints;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getFlag() {
        return this.flag == null ? "" : this.flag.toString();
    }

    @Override
    public int[] getHostileList() {
        int[] a = new int[this.attackFactions.size()];
        int i = 0;
        for (Integer val : this.attackFactions) {
            a[i++] = val;
        }
        return a;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean getIsHidden() {
        return this.hideFaction;
    }

    @Override
    public String getName() {
        return new TextComponentTranslation(this.name, new Object[0]).func_150254_d();
    }

    @Override
    public boolean hasHostile(int id) {
        return this.attackFactions.contains(id);
    }

    @Override
    public boolean hostileToFaction(int factionId) {
        return this.attackFactions.contains(factionId);
    }

    @Override
    public boolean hostileToNpc(ICustomNpc<?> npc) {
        return this.attackFactions.contains(npc.getFaction().getId());
    }

    public boolean isAggressiveToNpc(EntityNPCInterface entity) {
        return this.attackFactions.contains(entity.faction.id) || entity.advanced.attackFactions.contains(this.id);
    }

    public boolean isAggressiveToPlayer(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return false;
        }
        PlayerFactionData data = PlayerData.get((EntityPlayer)player).factionData;
        return data.getFactionPoints(player, this.id) < this.neutralPoints;
    }

    public boolean isFriendlyToPlayer(EntityPlayer player) {
        PlayerFactionData data = PlayerData.get((EntityPlayer)player).factionData;
        return data.getFactionPoints(player, this.id) >= this.friendlyPoints;
    }

    public boolean isNeutralToPlayer(EntityPlayer player) {
        PlayerFactionData data = PlayerData.get((EntityPlayer)player).factionData;
        int points = data.getFactionPoints(player, this.id);
        return points >= this.neutralPoints && points < this.friendlyPoints;
    }

    @Override
    public int playerStatus(IPlayer<?> player) {
        PlayerFactionData data = PlayerData.get(player.getMCEntity()).factionData;
        int points = data.getFactionPoints((EntityPlayer)player.getMCEntity(), this.id);
        if (points >= this.friendlyPoints) {
            return 1;
        }
        if (points < this.neutralPoints) {
            return -1;
        }
        return 0;
    }

    public void load(NBTTagCompound compound) {
        this.name = compound.func_74779_i("Name");
        if (compound.func_150297_b("Flag", 8)) {
            this.setFlag(compound.func_74779_i("Flag"));
        }
        if (compound.func_150297_b("Description", 8)) {
            this.description = compound.func_74779_i("Description");
        }
        this.color = compound.func_74762_e("Color");
        this.id = compound.func_74762_e("Slot");
        this.neutralPoints = compound.func_74762_e("NeutralPoints");
        this.friendlyPoints = compound.func_74762_e("FriendlyPoints");
        this.defaultPoints = compound.func_74762_e("DefaultPoints");
        this.hideFaction = compound.func_74767_n("HideFaction");
        this.getsAttacked = compound.func_74767_n("GetsAttacked");
        this.attackFactions = NBTTags.getIntegerSet(compound.func_150295_c("AttackFactions", 10));
        this.frendFactions = NBTTags.getIntegerSet(compound.func_150295_c("FrendFactions", 10));
        this.factions.load(compound.func_74775_l("FactionPoints"));
    }

    @Override
    public void removeHostile(int id) {
        this.attackFactions.remove(id);
    }

    @Override
    public void save() {
        FactionController.instance.saveFaction(this);
    }

    @Override
    public void setAttackedByMobs(boolean bo) {
        this.getsAttacked = bo;
    }

    @Override
    public void setDefaultPoints(int points) {
        this.defaultPoints = points;
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.description = description;
    }

    @Override
    public void setFlag(String flagPath) {
        if (flagPath == null || flagPath.isEmpty()) {
            this.flag = null;
            return;
        }
        this.flag = new ResourceLocation(flagPath);
    }

    @Override
    public void setIsHidden(boolean bo) {
        this.hideFaction = bo;
    }

    public NBTTagCompound save(NBTTagCompound compound) {
        compound.func_74768_a("Slot", this.id);
        compound.func_74778_a("Name", this.name);
        compound.func_74778_a("Flag", this.flag != null ? this.flag.toString() : "");
        compound.func_74778_a("Description", this.description);
        compound.func_74768_a("Color", this.color);
        compound.func_74768_a("NeutralPoints", this.neutralPoints);
        compound.func_74768_a("FriendlyPoints", this.friendlyPoints);
        compound.func_74768_a("DefaultPoints", this.defaultPoints);
        compound.func_74757_a("HideFaction", this.hideFaction);
        compound.func_74757_a("GetsAttacked", this.getsAttacked);
        compound.func_74782_a("AttackFactions", (NBTBase)NBTTags.nbtIntegerCollection(this.attackFactions));
        compound.func_74782_a("FrendFactions", (NBTBase)NBTTags.nbtIntegerCollection(this.frendFactions));
        compound.func_74782_a("FactionPoints", (NBTBase)this.factions.save(new NBTTagCompound()));
        return compound;
    }
}

